//--------------------------------------------------------------------
// $Id: FFV.hpp 4682 2007-01-25 05:10:59Z cjm $
//--------------------------------------------------------------------
//
//   Fast File Validator
//   Copyright 2000 by Christopher J. Madsen
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//--------------------------------------------------------------------

//--------------------------------------------------------------------
#ifdef _WIN32
#include "win32/StdAfx.h"
//--------------------------------------------------------------------
#else // Unix
#include "config.h"
#define FFV_VERSION PACKAGE_VERSION

#include <aio.h>
#include <errno.h>
#include <fcntl.h>
#include <ftw.h>
#include <glob.h>
#include <string.h>
#include <sys/stat.h>
#include <termios.h>
#include <unistd.h>

typedef unsigned char  BYTE;
typedef unsigned long  DWORD;
typedef int            errorT;
typedef int            fileT;

const fileT  invalidFile = -1;

const char *const  dirChars = "/";

// FTW_ACTIONRETVAL is a GNU extension.  If it's not available, we'll
// do without, but that means we won't ignore hidden directories.
#ifndef FTW_ACTIONRETVAL
#define FTW_ACTIONRETVAL 0
#define FTW_CONTINUE     0
#define FTW_SKIP_SUBTREE 0
#endif // not defined FTW_ACTIONRETVAL

#endif  // else not Win32

//--------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

//====================================================================
// Standard Template Library:

#ifdef _WIN32
#pragma warning(disable: 4786)
#endif

#include <algorithm>
#include <string>
#include <vector>

using namespace std;

//--------------------------------------------------------------------
// Strings:

#ifndef _T
#define _T(x) x
#endif

typedef string  String;

typedef String::size_type      StrIdx;
typedef String::iterator       StrItr;
typedef String::const_iterator StrConstItr;

//--------------------------------------------------------------------
// Vectors:

typedef vector<String>          StrVec;
typedef StrVec::iterator        SVItr;
typedef StrVec::const_iterator  SVConstItr;

typedef StrVec::size_type  VecSize;

//--------------------------------------------------------------------
// Exit codes:

const int
  exSuccess       = 0,
  exMissing       = 1,           // MISS
  exMismatch      = 2,           // BAD
  exIOError       = 3,           // ERR
  exInternalError = 4,
  exUsage         = 5;

//====================================================================
#include "GetOpt/GetOpt.hpp"
#include "MD5.hpp"
