//--------------------------------------------------------------------
// $Id: MD5.hpp 4640 2005-10-04 15:44:25Z cjm $
//--------------------------------------------------------------------
//
//   RSA Data Security, Inc. MD5 Message-Digest Algorithm
//
//   Translated from C to C++ by Christopher J. Madsen
//
//--------------------------------------------------------------------

#ifndef INCLUDED_MD5_HPP
#define INCLUDED_MD5_HPP

/* MD5.H - header file for MD5C.C
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

const int MD5DigestLen = 16;

class MD5
{
 private:
  DWORD  state[4];                                   /* state (ABCD) */
  DWORD  count[2];        /* number of bits, modulo 2^64 (lsb first) */
  BYTE   buffer[64];                         /* input buffer */

 public:
  MD5() { initialize(); };
  void  initialize();
  void  update(const void* inputBuf, DWORD inputLen);
  void  finalize(BYTE digest[MD5DigestLen]);
}; // end MD5

#endif // not INCLUDED_MD5_HPP
