//--------------------------------------------------------------------
// $Id: misc.cpp 4658 2006-08-19 19:09:08Z cjm $
//--------------------------------------------------------------------
//
//   Fast File Validator
//   Copyright 2004 by Christopher J. Madsen
//
//   Miscellaneous functions (POSIX version)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//--------------------------------------------------------------------

#define LAST_ERROR  errno

StrVec*        collectInto   = NULL;
const char*    collectIgnore = NULL;

int nftwCollectFunc(const char* filename, const struct stat* s, int flag,
                    struct FTW* sf)
{
  if ((flag == FTW_F) &&
      (!collectIgnore || strcmp(filename, collectIgnore)) &&
      (includeHidden  || filename[sf->base] != '.')) {
    // Remove "./" from the path, if present:
    if (strncmp(filename, "./", 2) == 0) {
      filename += 2;
      if (collectIgnore && !strcmp(filename, collectIgnore))
        return FTW_CONTINUE;    // This is the file we're creating
    } // end if filename begins with ./

      collectInto->push_back(filename);
  } // end if normal file that should be included

  // Skip hidden directories:
  //   Since FTW_SKIP_SUBTREE is a GNU extension, this won't work on
  //   systems that don't use GNU libc (or a GNU-compatible libc).
  if ((flag == FTW_D) &&
      !includeHidden  &&
      (filename[sf->base] == '.') &&
      strcmp(filename, "."))
    return FTW_SKIP_SUBTREE;

  return FTW_CONTINUE;
} // end nftwCollectFunc

//--------------------------------------------------------------------
// Read a key from stdin:
//
// Returns:
//   The key code

// Use this variable to remember original terminal attributes:
bool           saved_attributes_set = false;
struct termios saved_attributes;

void resetInputMode()
{
  if (saved_attributes_set)
    tcsetattr(STDIN_FILENO, TCSANOW, &saved_attributes);
} // end resetInputMode

int getKey()
{
  if (!saved_attributes_set) {
    struct termios tattr;

    // Make sure stdin is a terminal:
    if (!isatty(STDIN_FILENO))
      return -1;

    // Save the terminal attributes so we can restore them later:
    tcgetattr(STDIN_FILENO, &saved_attributes);
    saved_attributes_set = true;
    atexit(resetInputMode);

    // Set the funny terminal modes:
    tcgetattr(STDIN_FILENO, &tattr);
    tattr.c_lflag &= ~(ICANON|ECHO); // Clear ICANON and ECHO
    tattr.c_cc[VMIN] = 1;
    tattr.c_cc[VTIME] = 0;
    tcsetattr(STDIN_FILENO, TCSAFLUSH, &tattr);
  } // end if need to set terminal mode

  char c;

  if (read(STDIN_FILENO, &c, 1) != 1)
    return -1;

  return c;
} // end getKey
