#! /usr/bin/perl
#---------------------------------------------------------------------
# $Id: testPrereq.pl 4667 2006-08-30 19:36:53Z cjm $
# Copyright 2006 Christopher J. Madsen
#
# Make sure we have all the prerequisites for the FFV test suite
#---------------------------------------------------------------------

use strict;
use File::Temp 'tempdir';
use FindBin    '$Bin';
use Test::More;

# Make sure Inline::C works:

use Inline C => 'int haveInlineC() { return 1; }';

die "Inline C didn't work" unless haveInlineC() == 1;

# Make sure we've got the 'prove' command from Test::More:

my $prove = `prove --version 2>&1`;

unless ($? == 0) {
  my $signal = $? & 0xFF;
  my $status = $? >> 8;

  die "Error running prove (exit $status, signal $signal)";
} # end unless no error running prove

unless ($prove =~ /Test::.+ Perl/) {
  die "The 'prove' command doesn't appear to be the one from Test::More";
} # end unless the --version output seems to be correct

# If we got here, then it looks like we've got everything we need:
exit 0;
