//--------------------------------------------------------------------
// $Id: misc.cpp 4640 2005-10-04 15:44:25Z cjm $
//--------------------------------------------------------------------
//
//   Fast File Validator
//   Copyright 2004 by Christopher J. Madsen
//
//   Miscellaneous functions (Win32 version)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// Calculate the number of chars preceeding the filename:
//
// Input:
//   path:  A pathname or filename
//
// Returns:
//   The number of chars in the path component

int dirLength(const char* path)
{
  const char* s = strpbrk(path, dirChars);
  const char* last = NULL;
  while (s) {
    last = s;
    s = strpbrk(s+1, dirChars);
  }
  if (last)
    return (last - path) + 1;

  return 0;
} // end dirLength

//--------------------------------------------------------------------
// Read a key from the console:
//
// Returns:
//   The key code from _getch
//     For extended key codes (where _getch returns 00 or E0), the
//     second key code is returned in the hi byte of the word

int getKey()
{
  const int c = _getch();

  if (!c || (c == 0xE0))
    return _getch() * 0x100 + c;
  else
    return c;
} // end getKey
