#! /usr/bin/perl
#---------------------------------------------------------------------
# $Id: maketxt.pl 4640 2005-10-04 15:44:25Z cjm $
# Copyright 2005 Christopher J. Madsen
#
# Generate FFV.txt from FFV.pod
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#---------------------------------------------------------------------

use strict;
use Date::Format 'time2str';
use Pod::Text;

my ($name, $outfile) = @ARGV;

#---------------------------------------------------------------------
# Format FFV.pod using Pod::Text:

my $p = Pod::Text->new(loose => 1, indent => 4, width => 74, sentence => 1);

my $text;

open(OUT, '>', \$text) or die;

$p->parse_from_filehandle(\*STDIN, \*OUT);

close OUT;

#---------------------------------------------------------------------
# Now perform fixups:

# Fixup NAME section:
$text =~ s/^NAME\s+ffv/FFV/;

# Format section headings:
$text =~ s/^(?:  )?([A-Z ]+)$/ sprintf "\n%s %s", $1, ('-' x (69 - length $1))/meg;

# Only one blank line before SYNOPSIS
$text =~ s/\n(?=SYNOPSIS)//;

# Shift text back to left margin:
$text =~ s/^    //mg;
$text =~ s/^ (?=\S| *--)//mg;

# Remove blank lines from SYNOPSIS and align examples:
$text =~ s/\n(?=To create.* file: +ffv )//mg;
$text =~ s/^(To .+ files?:) +(?=ffv )/sprintf '%-24s', $1/meg;

# Remove any leftover trailing spaces:
$text =~ s/ +$//mg;

#---------------------------------------------------------------------
$name .= time2str(" (%B %e, %Y)", time);

$name =~ s/  / /g;              # Fixup single digit days

$name = (' ' x int((70 - length $name) / 2)) . $name . "\n\n";

#---------------------------------------------------------------------
open(OUT, '>', $outfile) or die;

print OUT $name, $text;

close OUT;
