#! /bin/sh
#---------------------------------------------------------------------
# $Id: runtests.sh 4662 2006-08-24 19:22:23Z cjm $
# Copyright 2006 Christopher J. Madsen
#
# Attempt to run the test suite for FFV
#---------------------------------------------------------------------

# If we're being run from the Makefile, change to the tools directory:
if test "X$srcdir" != "X" ; then
  builddir=`pwd`
  export FFV_EXE_PATH="$builddir/ffv"
  export PERL_INLINE_DIRECTORY="$builddir/.Inline"

  cd "$srcdir/tools"

  if test ! -d "$PERL_INLINE_DIRECTORY" ; then
    mkdir "$PERL_INLINE_DIRECTORY"
  fi
fi

## echo "scrdir = $srcdir"
## echo "PERL_INLINE_DIRECTORY = $PERL_INLINE_DIRECTORY"
## pwd

# Make sure we can find the test scripts:
if test ! -e testPrereq.pl ; then
  echo "Unable to locate the test suite."
  echo "Please run this in the tools directory (or use 'make check')."
  exit 77                       # Tell Makefile the test was skipped
fi

# If the prerequisites script runs ok, then run the tests:
if (perl testPrereq.pl) &>/dev/null ; then
  echo "Running tests for Fast File Validator..."
  prove testFFV.pl
  exit $?
else
  echo "You don't have the necessary prerequisites to run the test suite."
  echo ""
  echo "You need Perl 5 with the following modules:"
  echo "    File::Temp"
  echo "    FindBin"
  echo "    Inline::C"
  echo "    Test::More (including the 'prove' command"
  echo ""
  echo "To see what you're missing, run:"
  echo "  perl "`pwd`/testPrereq.pl
  echo ""
  exit 77                       # Tell Makefile the test was skipped
fi
