//--------------------------------------------------------------------
// $Id: verify.cpp 4682 2007-01-25 05:10:59Z cjm $
//--------------------------------------------------------------------
//
//   Fast File Validator
//   Copyright 2004 by Christopher J. Madsen
//
//   File verification (Win32 version)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License as
//   published by the Free Software Foundation; either version 2 of
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//--------------------------------------------------------------------

//====================================================================
// Loosely based on CRC_32.C from July 1997 Snippets:
//====================================================================

DWORD WINAPI crcThreadFunc(LPVOID)
{
  #include "../crc32.h"

  register DWORD crc = 0xFFFFFFFF;
  register BYTE* buf;
  register int   len;

  MD5  md5;
  int  bufferNum = 0;

  for (;;) {
    WaitForSingleObject(bufFull[bufferNum], INFINITE);

    buf = buffer[bufferNum];
    len = buflen[bufferNum];
//  if (len < 0) return 0;

    if (wantCRC) {
      for ( ; len; --len)
        crc = crc_32_tab[(crc ^ *(buf++)) & 0xFF] ^ (crc >> 8);
    } else
      md5.update(buf, len);

    if (buflen[bufferNum] < bufferSize) {
      SetEvent(bufEmpty[bufferNum]);
///   WaitForSingleObject(crcUsed, INFINITE);
      if (wantCRC) {
        sprintf(outputBuf, "%08lX", ~crc);
        crc = 0xFFFFFFFF;
      } else
        hexdigest(outputBuf, md5); // Also reinitializes md5
      SetEvent(crcReady);
    } // end if end of file
    else
      SetEvent(bufEmpty[bufferNum]);

    bufferNum = !bufferNum;
  } // end forever

  return 0;
} // end crcThreadFunc
//====================================================================
// End of Snippets based code
//====================================================================

//====================================================================
// Initialization and option processing:
//====================================================================
// Create synchronization objects:
//
// Returns:
//   true:   Events created successfully
//   false:  Failed

bool initEvents()
{
  if (!(crcReady = CreateEvent(NULL, false, false, NULL))) return false;
///if (!(crcUsed = CreateEvent(NULL, false, true,  NULL))) return false;

  for (int i = 0; i < 2; ++i) {
    if (!(bufEmpty[i] = CreateEvent(NULL, false, true,  NULL))) return false;
    if (!(bufFull[i]  = CreateEvent(NULL, false, false, NULL))) return false;
  }

  return true;
} // end initEvents

//====================================================================
// Create or verify a checksum file:

void createOrVerify(int argc, char* argv[])
{
  if (!initEvents()) {
    fputs("Event creation failed!\n", stderr);
    exitNow(exInternalError);
  }

  buffer = reinterpret_cast<DiskBuffer*>(
    VirtualAlloc(NULL, bufferSize*2, MEM_COMMIT, PAGE_READWRITE)
  );

  if (!buffer) {
    fputs("Failed to allocate buffer!\n", stderr);
    exitNow(exInternalError);
  }

  int bufferNum = 0;
  DWORD  bytesRead;
  bool   signalledEnd = false;

  HANDLE  thread = CreateThread(NULL, 0, crcThreadFunc, NULL, 0, &bytesRead);

  if (!thread) exitNow(exInternalError);

  FileList* sfv;
  if (md5Output || sfvOutput)
    sfv = new CreateFileList(outputFileName, ifExist, sfvOutput != 0,
                             argc, argv);
  else
    sfv = new VerifyFileList(argc, argv);

  HANDLE    inFile;
  int       step, interval, complete = 0;
  if (!sfv->getFile(inFile, step, interval, wantCRC))
    exitNow(sfv->getExitStatus());
  int count = interval;

///  DWORD  readTime = 0, startTime = GetTickCount();

  for (;;) {
    WaitForSingleObject(bufEmpty[bufferNum], INFINITE);
///    const DWORD startRead = GetTickCount();
    if (!ReadFile(inFile, buffer[bufferNum], bufferSize, &bytesRead, NULL)) {
      if (stopOnError) errorExit(sfv->currentFile(), exIOError);
      sfv->recordError();
      bytesRead = 0;
    }
///    readTime += GetTickCount() - startRead;

    buflen[bufferNum] = bytesRead;
    SetEvent(bufFull[bufferNum]);
    bufferNum = !bufferNum;

    if (wantProgress && !--count) {
      count = interval;
      printf("%3d\r", (complete += step) / pci);
    }

    if (bytesRead < bufferSize) { // End of file
      CloseHandle(inFile);
      if (wantProgress && !sfv->currentError()) fputs("100%\r", stdout);
//      printf("%3d %d %d ", complete/pci, step, interval);

      WaitForSingleObject(crcReady, INFINITE);
      sfv->setResult(outputBuf);
///   SetEvent(crcUsed);
      if (!sfv->getFile(inFile, step, interval, wantCRC))
        break;                  // No more files
      complete = 0;
      count    = interval;
    } // end if end of file
  } // end forever

  sfv->printResult();
  const int  status = sfv->getExitStatus();

/// const DWORD totalTime = GetTickCount() - startTime;
/// printf("%lu  %lu  %g\n", totalTime, readTime, (readTime * 100.0)/totalTime);

  delete sfv;
  VirtualFree(buffer, 0, MEM_RELEASE);

  exitNow(status);
} // end createOrVerify
